require 'page-object'

module Table
  include PageObject

  button(:addButton, :css => "button[ng-click='getDetails()']")

  elements(:tableList, :li, :css => "ol.table-list-body li")
  elements(:tableHeaders, :span, :css => ".table-list-head span")
  div(:noResultsMessage, :css => ".no-results-message[tabindex]")
  p(:table_desc, :css=>"p.list-desc")

  def getNthTableHeader(col)
   return  tableHeaders_elements[col - 1].text.strip
  end

  def getTableHeaders()
    headerCount = tableHeaders_elements.length

    puts "Header Count " + headerCount.to_s

    headers = []
    for i in 0...headerCount
      if self.tableHeaders_elements[i].exists?
        puts "text is " + tableHeaders_elements[i].text.strip
        if(tableHeaders_elements[i].text.strip != "" and tableHeaders_elements[i].text.strip != nil)
          headers << tableHeaders_elements[i].text.strip
        end
      end
    end
    return headers
  end

  def getTextForRowCol(row, col)
    self.class.span(:cell, :css => "ol.table-list-body li:nth-child(" + row.to_s + ") button span:nth-child(" +  (col + 1).to_s + ") .list-cell-data")
    return self.cell_element.text.strip
  end

  def getRowIndex(text, column)
    index = -1
    count = tableList_elements.length

    for i in 1..count
      cellText = getTextForRowCol(i, column.to_i)
      # puts "text  to find" + text.to_s
      # puts "cell text " + cellText
      if cellText.strip == text.to_s.strip
        index = i
        break
      end
    end

    #puts "index is " + index.to_s
    return index
  end



end